clear
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"

gen month = month(date)
gen day = day(date) 
gen quarter = quarter(date) 

drop if year < 2002
gen crisis = . 
replace crisis = 0 if year <= 2007 
replace crisis = 1 if year >= 2010
replace crisis = . if year == 2016 


by name year quarter, sort: egen tierone_avg=median(tierone)
by name year quarter, sort: egen car_avg=median(car)
by name year quarter, sort: egen lev_avg=median(lev)
by name year quarter, sort: egen vol_thirty_avg=median(vol_thirty)
by name year quarter, sort: egen impvol_avg=median(impvol)
by name year quarter, sort: egen beta_avg=median(beta)
by name year quarter, sort: egen tce_avg=median(tce)
drop output_indicator 
by name quarter quarter, sort: gen output_indicator = _n 
br if output_indicator == 1 

****first by tierone 

**** get two buckets one above and one below median in each quarter
egen quant_tierone = xtile(tierone_avg), n(10) by(year quarter) 
by quant_tierone year quarter, sort: egen vol_by_tierone=median(vol_thirty_avg)
by quant_tierone year quarter, sort: egen beta_by_tierone=median(beta_avg)
by quant_tierone year quarter, sort: egen impvol_by_tierone=median(impvol_avg)
by quant_tierone year quarter, sort: egen quant_by_tierone=median(tierone_avg)
drop output_indicator 
drop if quant_tierone == . 
by year quarter quant_tierone, sort: gen output_indicator = _n 
preserve
keep year quarter quant_tierone vol_by_tierone beta_by_tierone impvol_by_tierone quant_by_tierone quant_by_tierone beta_by_tierone impvol_by_tierone vol_by_tierone output_indicator
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tierone_byyear.dta", replace
restore, preserve

**** we want averages in each group before and after the crisis 
*by quant_tierone crisis, sort: egen vol_crisis = median(vol_by_tierone)
/*by quant_tierone crisis, sort: egen beta_crisis = median(beta_by_tierone)
by quant_tierone crisis, sort: egen impvol_crisis = median(impvol_by_tierone)
by quant_tierone crisis, sort: egen tierone_crisis = median(quant_by_tierone)
drop output_indicator 
by crisis quant_tierone, sort: gen output_indicator = _n 
preserve
drop if crisis == . 
keep crisis tierone_crisis impvol_crisis beta_crisis vol_crisis output_indicator 
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tierone.dta", replace
restore, preserve*/

***** now do the same with car 
egen quant_car = xtile(car_avg), n(10) by(year quarter) 
by quant_car year quarter, sort: egen vol_by_car=median(vol_thirty_avg)
by quant_car year quarter, sort: egen beta_by_car=median(beta_avg)
by quant_car year quarter, sort: egen impvol_by_car=median(impvol_avg)
by quant_car year quarter, sort: egen quant_by_car=median(car_avg)
drop output_indicator 
drop if quant_car == . 
by year quarter quant_car, sort: gen output_indicator = _n 
keep year quarter quant_car vol_by_car beta_by_car impvol_by_car quant_by_car quant_by_car beta_by_car impvol_by_car vol_by_car output_indicator
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/car_byyear.dta", replace
restore, preserve

**** we want averages in each group before and after the crisis 
/*by quant_car crisis, sort: egen vol_crisis = median(vol_by_car)
by quant_car crisis, sort: egen beta_crisis = median(beta_by_car)
by quant_car crisis, sort: egen impvol_crisis = median(impvol_by_car)
by quant_car crisis, sort: egen car_crisis = median(quant_by_car)
drop output_indicator 
by crisis quant_car, sort: gen output_indicator = _n 
drop if crisis == . 
keep crisis car_crisis impvol_crisis beta_crisis vol_crisis output_indicator 
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/car.dta", replace
restore, preserve*/

**** now do the same with lev
egen quant_lev = xtile(lev_avg), n(10) by(year quarter) 
by quant_lev year quarter, sort: egen vol_by_lev=median(vol_thirty_avg)
by quant_lev year quarter, sort: egen beta_by_lev=median(beta_avg)
by quant_lev year quarter, sort: egen impvol_by_lev=median(impvol_avg)
by quant_lev year quarter, sort: egen quant_by_lev=median(lev_avg)
drop output_indicator 
drop if quant_lev == . 
by year quarter quant_lev, sort: gen output_indicator = _n 
keep year quarter quant_lev vol_by_lev beta_by_lev impvol_by_lev quant_by_lev quant_by_lev beta_by_lev impvol_by_lev vol_by_lev output_indicator
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/lev_byyear.dta", replace
restore, preserve

**** we want averages in each group before and after the crisis 
/*by quant_lev crisis, sort: egen vol_crisis = median(vol_by_lev)
by quant_lev crisis, sort: egen beta_crisis = median(beta_by_lev)
by quant_lev crisis, sort: egen impvol_crisis = median(impvol_by_lev)
by quant_lev crisis, sort: egen lev_crisis = median(quant_by_lev)
drop output_indicator 
by crisis quant_lev, sort: gen output_indicator = _n 
drop if crisis == . 
keep crisis lev_crisis impvol_crisis beta_crisis vol_crisis output_indicator 
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/lev.dta", replace
restore, preserve*/

*** now the same with tce 
egen quant_tce = xtile(tce_avg), n(10) by(year quarter) 
by quant_tce year quarter, sort: egen vol_by_tce=median(vol_thirty_avg)
by quant_tce year quarter, sort: egen beta_by_tce=median(beta_avg)
by quant_tce year quarter, sort: egen impvol_by_tce=median(impvol_avg)
by quant_tce year quarter, sort: egen quant_by_tce=median(tce_avg)
drop output_indicator 
drop if quant_tce == . 
by year quarter quant_tce, sort: gen output_indicator = _n 
keep year quarter quant_tce vol_by_tce beta_by_tce impvol_by_tce quant_by_tce quant_by_tce beta_by_tce impvol_by_tce vol_by_tce output_indicator
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tce_byyear.dta", replace
restore, preserve

**** we want averages in each group before and after the crisis 
/*by quant_tce crisis, sort: egen vol_crisis = median(vol_by_tce)
by quant_tce crisis, sort: egen beta_crisis = median(beta_by_tce)
by quant_tce crisis, sort: egen impvol_crisis = median(impvol_by_tce)
by quant_tce crisis, sort: egen tce_crisis = median(quant_by_tce)
drop output_indicator 
by crisis quant_tce, sort: gen output_indicator = _n 
drop if crisis == . 
keep crisis tce_crisis impvol_crisis beta_crisis vol_crisis output_indicator 
drop if output_indicator != 1
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/Quintile/tce.dta", replace
restore, preserve*/
